import math

def load(list):
    print "Loading AI bindings"

    # binding format:
    # ( 'name of robot from .bot file', 'name of AI from script class',
    #       {'optional constructor parameter':value, 'another':value} )

    # constructor parameters:
    # nose - "front" of bot in radians (default 0)
    # invertible - can function upside-down (default False)
    # topspeed - speed in meters/second AI will attempt not to exceed (default 4.0)
    # throttle - maximum analog value AI will attempt not to exceed (default 100)
    # turnspeed - turning in radians/second AI will attempt not to exceed (default 2.5)
    # turn - maximum analog value AI will attempt not to exceed (default 60)
    # radius - bot radius to use for checking for hazards and walls (default 1.0)

    # 0 - Red Zone "That's where your bot will be after ten seconds with ours!"
    list.append(("Scout","Flipper",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':100,'turn':30,'turnspeed':5,'weapons':(8,9)}))
    list.append(("RED ALERT","Poker",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':5,'weapons':(13,14,16,17,18)}))
    list.append(("Second Sentinel","Flipper",{'nose':math.pi*2,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':5,'weapons':(18,19)}))
    list.append(("T-Minus","Poker",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(25,)}))
    list.append(("Biohazard","Poker",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(4,)}))
    list.append(("Dreadnought","Omni",{'invertible':True,'nose':math.pi,'range':99,'radius':0.1,'topspeed':100,'throttle':80,'turn':25,'turnspeed':1.5,'weapons':(20,)}))

    # 1 - PREHISTORIC "Badder and still bloodthirsty!"
    list.append(("Roly Poly","Rammer",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5}))
    list.append(("Saber Teeth","Omni",{'invertible':True,'nose':math.pi*2,'radius':0.2,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3.5,'weapons':(10,11,12,13,14,15,16,17,18,19)}))
    list.append(("Grog, the Vengeful","Spinner",{'nose':math.pi*2.25,'range':500,'radius':1,'topspeed':3,'throttle':130,'turn':60,'turnspeed':5,'weapons':(27,28,29,30,35,36,37,38,39,40,41,42,43,44,45,46,47,48,53,54)}))
    list.append(("Robot X","Rammer",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5}))
    list.append(("Matilda","DirectionalSpinner",{'nose':-math.pi/2,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(24,25,26)}))
    list.append(("Behemoth","Omni",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(6,23)}))

    # 2 - The Good Ol' Boys "Don't need nuthin' but my truck, my shotgun, my new bots, and my REVENGE!"
    list.append(("Hammerhead Shark","Rammer",{'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5}))
    list.append(("Blood Runner","Omni",{'invertible':True,'nose':math.pi*2,'radius':.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(3,4,5,6)}))
    list.append(("Grisly Bear","Poker",{'invertible':True,'nose':math.pi*2,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':30,'turnspeed':3,'weapons':(22,23,24,25)}))
    list.append(("Billy-Bot","Omni",{'invertible':True,'nose':math.pi,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(17,)}))
    list.append(("Wheely Big Cheese","Poker",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(6,)}))
    list.append(("Thermidor II","SwitchWep",{'nose':math.pi*2,'radius':1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(11,),'sweapons':(28,29,)}))

    # 3 - Team Dragon "If you defeat us again, we will sneak in at night and steal your bots."
    list.append(("Ninja Assassin","Omni",{'nose':math.pi*2,'range':99,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2,'weapons':(4,5)}))
    list.append(("Samurai","Flipper",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3.5,'weapons':(9,10)}))
    list.append(("Shogun","Flipper",{'nose':math.pi*2,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':1,'weapons':(13,14,15,16)}))
    list.append(("Bob","DirectionalSpinner",{'radius':0.3,'range':2.5,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(25,)}))
    list.append(("FireStorm","Poker",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(19,)}))
    list.append(("Ronin","Omni",{'invertible':True,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(55,)}))

    # 4 - BLACK STORM "The BLACK STORM was only getting started with our old bots!"
    list.append(("BOT-205","Omni",{'invertible':True,'nose':math.pi*2,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(19,)}))
    list.append(("Devil II","Pusher",{'nose':math.pi*2,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2}))
    list.append(("Industrial Coal Miner","Omni",{'invertible':True,'nose':math.pi*2,'radius':0.1,'range':99,'topspeed':150,'throttle':130,'turn':60,'turnspeed':4,'weapons':(29,41,42)}))
    list.append(("Cleprechaun","Omni",{'nose':math.pi,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':25,'turnspeed':3,'weapons':(7,)}))
    list.append(("Shrederator","Spinner",{'nose':math.pi,'radius':0.1,'range':99,'topspeed':6,'throttle':60,'turn':60,'turnspeed':2.5,'weapons':(15,)}))
    list.append(("El Diablo","Omni",{'invertible':True,'nose':math.pi,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':30,'turnspeed':3,'weapons':(25,29)}))

    # 5 - Team SPARK "EMERGENCY is back with a vengeance, faster and more furious."
    list.append(("BROKE!","Omni",{'invertible':True,'nose':math.pi*2,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(12,)}))
    list.append(("The Boxer Returns","Poker",{'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':130,'turnspeed':5,'weapons':(12,17)}))
    list.append(("CRITICAL EMERGENCY","Flipper",{'nose':math.pi*2,'radius':0.1,'topspeed':150,'throttle':130,'turn':60,'turnspeed':2,'weapons':(9,10,11,12)}))
    list.append(("Ziggo","Spinner",{'nose':math.pi,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(11,)}))
    list.append(("Potters Wheel","Omni",{'nose':math.pi,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':30,'turnspeed':2.5,'weapons':(21,)}))
    list.append(("Overkill","Frenzy",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(15,)}))

    # 6 - Spike Heads "I'd like you to meet my big metal friend..."
    list.append(("Raving M.A.D.","Rammer",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5}))
    list.append(("iNsAnItY","Flipper",{'nose':math.pi*2,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(5,)}))
    list.append(("Big Metal Friend","Omni",{'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2,'weapons':(39,42)}))
    list.append(("SlapHappy","Whipper",{'invertible':True,'nose':math.pi,'whip':"around",'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(9,10)}))
    list.append(("Hypno-Disc","Omni",{'nose':math.pi,'radius':.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(28,29)}))
    list.append(("Panic Attack","Omni",{'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(24,)}))

    # 7 - North Polers "Sorry, no Santa Claus here."
    list.append(("Tip of the Iceberg","Omni",{'nose':math.pi*2,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3.5,'weapons':(14,15,16)}))
    list.append(("Iceberg","Omni",{'nose':math.pi*2,'radius':0.1,'topspeed':15,'throttle':130,'turn':60,'turnspeed':2,'weapons':(11,12,13)}))
    list.append(("Snow Job","Pusher",{'invertible':True,'radius':0.1,'topspeed':150,'throttle':130,'turn':60,'turnspeed':2}))
    list.append(("S3","Omni",{'invertible':True,'nose':math.pi,'range':99,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(13,)}))
    list.append(("Vladiator Poker","Rammer",{'invertible':True,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(19,)}))
    list.append(("Beta","Frenzy",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(39,)}))

    # 8 - HIGH VOLTAGE "If only electric shock was a legal weapon."
    list.append(("FlipJack","Flipper",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(6,13)}))
    list.append(("SlashBack","Flipper",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(18,19,20,21)}))
    list.append(("WIIDE LOAD","Omni",{'invertible':True,'nose':math.pi*2,'radius':0.1,'range':500,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54)}))
    list.append(("Lightning","Poker",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(10,11)}))
    list.append(("Storm II","Poker",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(33,)}))
    list.append(("Sir Killalot","Omni",{'invertible':True,'nose':math.pi,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(25,29)}))

    # 9 - Team HEX "We eat nuts and bolts for breakfast."
    list.append(("Grim Chopper","Omni",{'nose':math.pi*2,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':25,'turnspeed':3,'weapons':(16,)}))
    list.append(("Lock Nut","Spinner",{'nose':math.pi*1.5,'radius':0.3,'range':500,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(10,11,12)}))
    list.append(("Cranky Spanky","Omni",{'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(7,8,34,35,37,38)}))
    list.append(("Pussycat","Omni",{'invertible':True,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(21,)}))
    list.append(("Mechavore","Omni",{'nose':math.pi,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(20,)}))
    list.append(("Techno Destructo","Omni",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(13,)}))

    # 10 - Team Z "Still cooler than you."
    list.append(("Insane Berserker","Spinner",{'nose':math.pi,'range':99,'radius':0.5,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(9,10,11)}))
    list.append(("Razorback","Flipper",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':30,'turnspeed':2,'weapons':(25,)}))
    list.append(("Eye Stabber","Poker",{'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(18,19,20,21)}))
    list.append(("Complete Control","Poker",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(2,13)}))
    list.append(("Tazbot","Omni",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(11,)}))
    list.append(("Razer","Omni",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':100,'turnspeed':4,'weapons':(7,)}))

    # 11 - SteelYard Dog "They don't have much of a bite, but they sure can PUSH!"
    list.append(("Mangy Mutt","Pusher",{'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5}))
    list.append(("Top Dog","Pusher",{'invertible':True,'nose':math.pi*2,'radius':0.2,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5}))
    list.append(("Bad Dog","Pusher",{'invertible':True,'nose':math.pi*2,'radius':0.2,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5}))
    list.append(("Growler","Poker",{'nose':math.pi,'radius':1,'topspeed':12,'throttle':100,'turn':30,'turnspeed':2.5,'weapons':(14,16)}))
    list.append(("Bulldog Breed","Flipper",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':30,'turnspeed':2.5,'weapons':(1,)}))
    list.append(("Killdozer","Rammer",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(10,)}))

    # 12 - RIOT "Things are going to get even LOUDER!"
    list.append(("Civil Uprising","DirectionalSpinner",{'invertible':True,'nose':math.pi*2,'radius':0.2,'range':500,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(5,6,7,8)}))
    list.append(("VENGEANCE","DirectionalSpinner",{'invertible':True,'nose':math.pi*2,'range':500,'radius':0.4,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(8,9,10,11)}))
    list.append(("Velociraptor","Omni",{'nose':math.pi*2,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':30,'turnspeed':1.5,'weapons':(56,57,58,59,60,61)}))
    list.append(("Whack!","Omni",{'nose':math.pi*2,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(11,)}))
    list.append(("frenZy","Frenzy",{'nose':math.pi/2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(26,)}))
    list.append(("Chaos2","Poker",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(14,)}))

    # 13 - MEGATON "KABBBBOOOOOOOOOOOMMMMM!!!!!!!!"
    list.append(("Poison Stinger","Poker",{'invertible':True,'nose':math.pi*2,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(10,11,12,13)}))
    list.append(("Tempest","Spinner",{'nose':math.pi*2,'radius':0.5,'range':500,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(18,19,20,21,26,27)}))
    list.append(("UnDeadbeat","Omni",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(31,)}))
    list.append(("WhirlWep","Omni",{'invertible':True,'nose':-math.pi/2,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(19,)}))
    list.append(("Supernova","DirectionalSpinner",{'invertible':True,'nose':math.pi,'range':99,'radius':0.1,'range':99,'topspeed':90,'throttle':100,'turn':60,'turnspeed':2.5,'weapons':(10,)}))
    list.append(("Typhoon","Spinner",{'nose':math.pi/2,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(22,23,24,25)}))

    # 14 - The Scrappers "We scrap junk for a living, so your bots won't be a problem at all."
    list.append(("360 Arc Pounder","Whipper",{'invertible':True,'whip':"around",'nose':math.pi,'radius':1.5,'topspeed':12,'throttle':20,'turn':30,'turnspeed':1,'weapons':(9,11)}))
    list.append(("Ripblade II","DirectionalSpinner",{'invertible':True,'nose':math.pi*2,'radius':1,'range':500,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2,'weapons':(17,18,19,20,21,22,23,24,25,26,27,28)}))
    list.append(("Backyard Shredder","Omni",{'nose':math.pi*2,'radius':0.1,'range':500,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(33,45,46)}))
    list.append(("Flip Test Dummy","Rammer",{'invertible':True,'radius':2,'topspeed':100,'throttle':120,'turn':60,'turnspeed':4}))
    list.append(("The Stuff of Champions","Omni",{'nose':math.pi*2,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':4,'weapons':(16,17)}))
    list.append(("WreckTangle 2","Rammer",{'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':4}))

    #15 - Discs of Doom
    list.append(("Backlash","Omni",{'nose':math.pi,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(12,)}))
    list.append(("259","Omni",{'nose':math.pi,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(4,)}))
    list.append(("Nightmare","DirectionalSpinner",{'nose':-math.pi/2,'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':30,'turnspeed':1,'weapons':(9,10)}))
    list.append(("Tornado","Omni",{'invertible':True,'nose':math.pi,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':30,'turnspeed':2.5,'weapons':(21,)}))
    list.append(("Heavy Metal Noise","DirectionalSpinner",{'invertible':True,'nose':math.pi*2,'range':99,'radius':0.4,'topspeed':100,'throttle':130,'turn':30,'turnspeed':2,'weapons':(16,17,18,19)}))
    list.append(("Minion","Omni",{'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(42,)}))

    # 16 - Radioactive Meltdown
    list.append(("That Darn Dustpan!","LittleMetalFriend",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(25,)}))
    list.append(("Vladiator","Poker",{'invertible':True,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Vlad the Impaler","Omni",{'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(8,)}))
    list.append(("Wedge of Doom","Poker",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,)}))
    list.append(("Dominator 2","Omni",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3.5,'weapons':(14,15,25)}))
    list.append(("The Judge","Omni",{'nose':math.pi*2,'radius':0.1,'reload':16,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(53,)}))

    # 17 - BBEANS Champions
    list.append(("Smashbox 2","Smashbox",{'nose':math.pi,'radius':1,'reload':8,'topspeed':18,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(20,),'sweapons':(21,),'tweapons':(22,),'qweapons':(23,)}))
    list.append(("Mako","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':1.4,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.2,'weapons':(25,26)}))
    list.append(("Shebeast","SwitchWep",{'invertible':True,'range':99,'nose':math.pi*2,'radius':1.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3.5,'weapons':(36,37,38,39,40,41,42,51,52,53,54,55,56,57,58,59,62,63),'sweapons':(20,)}))
    list.append(("YU812","Spinner",{'radius':0.1,'range':99,'topspeed':6,'throttle':50,'turn':60,'turnspeed':2.5,'weapons':(19,20,21)}))
    list.append(("Tornado Mer","Spinner",{'nose':math.pi/2.5,'range':99,'radius':0.3,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(10,11,12)}))
    list.append(("Hworf","Omni",{'invertible':True,'nose':math.pi*2,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':30,'turnspeed':2.5,'weapons':(5,7)}))

    # 18 - Robot Arena Reincarnated
    list.append(("Gammaraze III","Omni",{'invertible':True,'nose':math.pi*2,'radius':0.1,'range':500,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(12,20,22,36,37,40)}))
    list.append(("Topknot II","Topknot",{'invertible':False,'whip':"around",'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(29,30,31,32,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69)}))
    list.append(("ScootOrDie","Poker",{'nose':math.pi,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2,'weapons':(35,36,37)}))
    list.append(("Aquarius 2","Poker",{'nose':math.pi*2,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':1.5,'weapons':(20,23,29)}))
    list.append(("Pon2n","Omni",{'nose':math.pi,'radius':0,'range':50,'topspeed':100,'throttle':130,'turn':60,'turnspeed':1.5,'weapons':(39,40,42,43,47,48)}))
    list.append(("Triclops v2.0","Omni",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':130,'turnspeed':2.5,'weapons':(23,24,25)}))

    # 19 - Arthrobotics
    list.append(("AW-Nanowhirl","Spinner",{'nose':math.pi*2,'range':15,'radius':0.4,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(2,)}))
    list.append(("AW-Terminus","Omni",{'nose':math.pi*2,'radius':0.1,'range':15,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(17,)}))
    list.append(("BW-Microwhirl","Spinner",{'nose':math.pi*2,'range':30,'radius':0.4,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(6,9,10,11,12)}))
    list.append(("BW-True Love","Omni",{'invertible':True,'nose':math.pi*2,'radius':0.1,'range':30,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(12,13,14,15)}))
    list.append(("BW-Peer Pressure","Flipper",{'nose':math.pi*2,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':4.5,'weapons':(10,)}))
    list.append(("BW-Robokillase","Rammer",{'invertible':True,'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5}))

    # 20 - Team RA2
    list.append(("Apollyon","Pusher",{'nose':math.pi*2,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5}))
    list.append(("Ruiner","DirectionalSpinner",{'nose':math.pi,'radius':0.5,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(7,8,9)}))
    list.append(("Buster Blade","DirectionalSpinner",{'nose':math.pi*2,'radius':0.2,'range':50,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(16,17)}))
    list.append(("Vertigo","DirectionalSpinner",{'nose':math.pi*2,'radius':0.2,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(20,21)}))
    list.append(("M.O.E.","DirectionalSpinner",{'invertible':True,'nose':math.pi,'range':99,'radius':.5,'turn':30,'turnspeed':2.5,'weapons':(12,13,25,26,27,28,29,30)}))

    # 21- R1885
    list.append(("Gyroman3","Spinner",{'range':99,'radius':1,'topspeed':100,'weapons':(1,2,3)}))
    list.append(("Flashback","Omni",{'invertible':False,'nose':math.pi,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(11,)}))
    list.append(("Flashman","Omni",{'invertible':False,'nose':math.pi,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(11,)}))
    list.append(("Crashman V3","Omni",{'topspeed':99,'nose':math.pi,'throttle':130,'radius':0.1,'range':99,'weapons':(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23)}))
    list.append(("S.D.V.","Omni",{'invertible':False,'nose':math.pi,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(11,)}))
    list.append(("The World Ends with You","Omni",{'invertible':False,'nose':math.pi,'range':99,'radius':0.1,'topspeed':100,'throttle':180,'turn':60,'turnspeed':2.5,'weapons':(11,)}))

    # 22- Exile
    list.append(("Exile Wip","Omni",{'nose':math.pi,'radius':1,'topspeed':100,'weapons':(1,2,3)}))
    list.append(("X-ile","Omni",{'invertible':True,'range':99,'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':3,'weapons':(1,2,3,4,5,6,7)}))
    list.append(("Exile","Popup",{'invertible':False,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(11,)}))
    list.append(("AW-Brith of Exile","Rammer",{'invertible':True,'nose':math.pi,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(11,)}))
    list.append(("BW-Growth of Exile","Rammer",{'invertible':True,'nose':math.pi,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(11,)}))
    list.append(("Exile's Rath","Omni",{'invertible':False,'nose':math.pi,'range':99,'radius':0.1,'topspeed':100,'throttle':180,'turn':60,'turnspeed':2.5,'weapons':(11,)}))

    # 22- Exile
    list.append(("Minor Launch Platform","Popup",{'radius':1,'topspeed':100,'weapons':(1,2,3)}))
    list.append(("Launch Platform","Popup",{'invertible':True,'nose':math.pi,'range':99,'topspeed':99,'throttle':130,'turn':60,'turnspeed':3,'weapons':(1,2,3,4,5,6,7)}))
    list.append(("T.H.R.U.S.T.","Omni",{'invertible':False,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(11,)}))
    list.append(("AW- Micro Launch Platform","Popup",{'invertible':True,'nose':math.pi,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(11,)}))
    list.append(("BW-Micro Launch Platform +","Popup",{'invertible':True,'nose':math.pi,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(11,)}))
    list.append(("SHW-Sky High","Omni",{'invertible':True,'nose':math.pi,'range':99,'radius':0.1,'topspeed':100,'throttle':180,'turn':60,'turnspeed':2.5,'weapons':(11,)}))

    # 23- Enforec
    list.append(("The Man With Broken Guns","Pusher",{'nose':math.pi,'radius':1,'topspeed':100,'weapons':(1,2,3)}))
    list.append(("Long Arm of the Law","Omni",{'nose':math.pi,'invertible':True,'radius':0.1,'topspeed':99,'throttle':130,'turn':60,'turnspeed':3,'weapons':(1,2,3,4,5,6,7)}))
    list.append(("S.W.A.T.","Omni",{'invertible':True,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(11,)}))
    list.append(("BW-Bage","Omni",{'invertible':True,'nose':math.pi,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(11,)}))
    list.append(("K9","Omni",{'invertible':True,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(11,)}))
    list.append(("Maverick Hunter","Omni",{'invertible':False,'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':180,'turn':60,'turnspeed':2.5,'weapons':(11,)}))

    
    
